require( "scripts/style.lua" );


InfoFont = {
  standardFont,
  30,
  BorderColor
};

function SetupUGCGameMode() 
	ForceMyWaiterCreation(true);
	SetCurrentGameMode(1);
	SetLevelMode(0);
	SetMultiplayer("single");
	SetMultiplayerLevelTestMode(false);
	MarkUGCReturnInfo();
end


MakeDialog
{
	PopThroughBitmap
	{
		name="backgroundimage",
		image="backgrounds/popup",
		x=kCenter,
		y=kCenter,
		
		Text
		{
			font = InfoFont,
			name = "difficulty",
			x=31,y=20,w=404,h=60,
			flags = kHAlignCenter + kVAlignTop,
			label = "choosedifficulty"
		};
			
			
		SetStyle(DifficultyButtonStyle);
		Button
		{
			x=30,
			y=115,
			name="easy",
			label="easy",
			type = kPush,
			command=
				function()
					SetupUGCGameMode();
					SetCurrentLevel(0);
					PreloadCustomers();
					CloseAllWindows();
					DoModal("scripts/game.lua");
				end
		},	
		
		Button
		{
			x=kCenter,
			y=115,
			name="medium",
			label="medium",
			type = kPush,
			command=
				function()
					SetupUGCGameMode();
					SetCurrentLevel(1);
					PreloadCustomers();
					CloseAllWindows();
					DoModal("scripts/game.lua");
				end
		},
		
		Button
		{
			x=312,
			y=115,
			name="hard",
			label="hard",
			type = kPush,
			command=
				function()
					SetupUGCGameMode();
					SetCurrentLevel(2);
					PreloadCustomers();
					CloseAllWindows();
					DoModal("scripts/game.lua");
				end
		},

		SetStyle(DifficultyApplyButtonStyle);
		Button
		{
			x=kCenter,
			y=205,
			name="back",
			label="back",
			command=
				function()
					PopModal("scripts/chooseugcdifficulty.lua");
				end
		},
		SetStyle(DefaultStyle);
			
	},
	
	
}
